﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.IO.Ports;
using System.Windows.Threading;
using System.Media;

namespace RobotRemCtrl
{
    /// <summary>
    /// Interaction logic for Window1.xaml
    /// </summary>
    public partial class Window1 : Window
    {
        private static SerialPort m_Port;
        private DispatcherTimer m_timerTelem;
        private enum Direction
        {
            Halt,
            Forward,
            Reverse
        }
        private Direction m_Direction;
        private int m_TelemCount = 1;

        public Window1()
        {
            InitializeComponent();

            try
            {
                Rect bounds = Properties.Settings.Default.WinPosition;
                this.Top = bounds.Top;
                this.Left = bounds.Left;
                this.Height = bounds.Height;
                this.Width = bounds.Width;
            }
            catch
            {
            }
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            m_Port.Close();

            Properties.Settings.Default.WinPosition = this.RestoreBounds;
            Properties.Settings.Default.Save();
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            try
            {
                m_Port = new SerialPort(Properties.Settings.Default.ComPort, 9600);
                m_Port.DataBits = 8;
                m_Port.StopBits = StopBits.One;
                m_Port.Parity = Parity.None;
                m_Port.Handshake = Handshake.None;
                m_Port.WriteTimeout = 500;
                m_Port.ReadTimeout = 1000;
                m_Port.NewLine = "\r";

                m_Port.Open();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Com Port Open Error", MessageBoxButton.OK, MessageBoxImage.Error);
            }

            m_timerTelem = new DispatcherTimer();
            m_timerTelem.Interval = TimeSpan.FromMilliseconds(1000);
            m_timerTelem.Tick += new EventHandler(AutoTelemetryHandler);
        }

        private void btnClose_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void btnSlow_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("S1");
        }

        private void btnMedium_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("S2");
        }

        private void btnFast_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("S3");
        }

        private void btnForward_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("FW");
            m_Direction = Direction.Forward;
        }

        private void btnStop_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("ST");
            m_Direction = Direction.Halt;
        }

        private void btnBack_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("BK");
            m_Direction = Direction.Reverse;
        }

        private void btnLeft_PreviewMouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            SendCommand("LF");
        }

        private void btnLeft_PreviewMouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            if (m_Direction == Direction.Forward)
                SendCommand("FW");
            else if (m_Direction == Direction.Reverse)
                SendCommand("BK");
            else
                SendCommand("ST");
        }

        private void btnRight_PreviewMouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            SendCommand("RT");
        }

        private void btnRight_PreviewMouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            if (m_Direction == Direction.Forward)
                SendCommand("FW");
            else if (m_Direction == Direction.Reverse)
                SendCommand("BK");
            else
                SendCommand("ST");
        }

        private void Window_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            switch (e.Key)
            {
                case Key.F1:
                case Key.D1:
                    SendCommand("S1");
                    break;

                case Key.F2:
                case Key.D2:
                    SendCommand("S2");
                    break;

                case Key.F3:
                case Key.D3:
                    SendCommand("S3");
                    break;

                case Key.NumPad8:
                    SendCommand("FW");
                    m_Direction = Direction.Forward;
                    break;

                case Key.NumPad5:
                    SendCommand("ST");
                    m_Direction = Direction.Halt;
                    break;

                case Key.NumPad2:
                    SendCommand("BK");
                    m_Direction = Direction.Reverse;
                    break;

                case Key.NumPad4:
                    SendCommand("LF");
                    break;

                case Key.NumPad6:
                    SendCommand("RT");
                    break;

                case Key.R:
                    SendCommand("VU");
                    break;

                case Key.F:
                    SendCommand("VC");
                    break;

                case Key.V:
                    SendCommand("VD");
                    break;

                case Key.D:
                    SendCommand("VL");
                    break;

                case Key.G:
                    SendCommand("VR");
                    break;

                case Key.S:
                    SendCommand("VS");
                    break;
            }
        }

        private void Window_PreviewKeyUp(object sender, KeyEventArgs e)
        {
            switch (e.Key)
            {
                case Key.NumPad4:
                case Key.NumPad6:
                    if (m_Direction == Direction.Forward)
                        SendCommand("FW");
                    else if (m_Direction == Direction.Reverse)
                        SendCommand("BK");
                    else
                        SendCommand("ST");
                    break;
            }
        }

        private void btnVidUp_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("VU");
        }

        private void btnVidLeft_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("VL");
        }

        private void btnVidCenter_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("VC");
        }

        private void btnVidRight_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("VR");
        }

        private void btnVidDown_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("VD");
        }

        private void btnVidScan_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("VS");
        }

        private void btnMotors_Checked(object sender, RoutedEventArgs e)
        {
            SendCommand("M1");
        }

        private void btnMotors_Unchecked(object sender, RoutedEventArgs e)
        {
            SendCommand("M0");
        }

        private void btnVid_Checked(object sender, RoutedEventArgs e)
        {
            SendCommand("V1");
        }

        private void btnVid_Unchecked(object sender, RoutedEventArgs e)
        {
            SendCommand("V0");
        }

        private void btnAux_Checked(object sender, RoutedEventArgs e)
        {
            SendCommand("A1");
        }

        private void btnAux_Unchecked(object sender, RoutedEventArgs e)
        {
            SendCommand("A0");
        }

        private void btnCamManual_Click(object sender, RoutedEventArgs e)
        {
            if ((bool)btnCamMotion.IsChecked || (bool)btnCamTimeLapse.IsChecked)
            {
                SendCommand("C0");
                btnCamMotion.IsChecked = false;
                btnCamTimeLapse.IsChecked = false;
            }
            else
            {
                SendCommand("SH");
            }
        }

        private void btnCamMotion_Checked(object sender, RoutedEventArgs e)
        {
            SendCommand("C1");
        }

        private void btnCamMotion_Unchecked(object sender, RoutedEventArgs e)
        {
            SendCommand("C0");
        }

        private void btnCamTimeLapse_Checked(object sender, RoutedEventArgs e)
        {
            SendCommand("C2");
        }

        private void btnCamTimeLapse_Unchecked(object sender, RoutedEventArgs e)
        {
            SendCommand("C0");
        }

        private void btnClearTel_Click(object sender, RoutedEventArgs e)
        {
            lstTelemetry.Items.Clear();
            m_TelemCount = 1;
            m_Port.DiscardInBuffer();
        }

        private void btnRequestTel_Click(object sender, RoutedEventArgs e)
        {
            SendCommand("DT");
            string tel = "";
            try
            {
//                tel = "$TL1,1,1,0,50,1,0,8";
                tel = m_Port.ReadLine();
            }
            catch
            {
            }

            StringBuilder parsed = new StringBuilder();

            if (tel.StartsWith("$TL"))
            {
                string[] items = tel.Substring(3).Split(',');

                if (m_TelemCount > 100)
                    btnClearTel_Click(null, null);
                parsed.Append(m_TelemCount.ToString() + ". ");
                m_TelemCount++;

                // Motors power
                parsed.Append("Motors ");
                if (items[0] == "0")
                {
                    parsed.Append("Off");
                    btnMotors.IsChecked = false;
                }
                else
                {
                    parsed.Append("On");
                    btnMotors.IsChecked = true;
                }

                // Video power
                parsed.Append(", Vid ");
                if (items[1] == "0")
                {
                    parsed.Append("Off");
                    btnVid.IsChecked = false;
                }
                else
                {
                    parsed.Append("On");
                    btnVid.IsChecked = true;
                }

                // Aux power
                parsed.Append(", Aux ");
                if (items[2] == "0")
                {
                    parsed.Append("Off");
                    btnAux.IsChecked = false;
                }
                else
                {
                    parsed.Append("On");
                    btnAux.IsChecked = true;
                }

                // Motion
                parsed.Append(", Motion ");
                if (items[3] == "0")
                    parsed.Append("No");
                else
                {
                    parsed.Append("Yes");
                    SoundPlayer player = new SoundPlayer();
                    player.Stream = Properties.Resources.CabinAlert;
                    player.Play();
                }

                // Speed
                parsed.Append(", ");
                switch (items[4])
                {
                    case "20":
                        parsed.Append("Slow");
                        break;
                    case "50":
                        parsed.Append("Medium");
                        break;
                    case "70":
                        parsed.Append("Fast");
                        break;
                }

                // Direction
                parsed.Append(", ");
                switch (items[5])
                {
                    case "0":
                        parsed.Append("Stop");
                        break;
                    case "1":
                        parsed.Append("Fwd");
                        break;
                    case "2":
                        parsed.Append("Back");
                        break;
                    case "3":
                        parsed.Append("CW");
                        break;
                    case "4":
                        parsed.Append("CCW");
                        break;
                }

                // Camera Mode
                parsed.Append(", Cam ");
                switch (items[6])
                {
                    case "0":
                        parsed.Append("Manual");
                        break;
                    case "1":
                        parsed.Append("Motion");
                        break;
                    case "2":
                        parsed.Append("TimeLapse");
                        break;
                }

                // Shutter fire count
                parsed.Append(", ");
                parsed.Append(items[7]);
            }
            else
            {
                parsed.Append("???");
                m_Port.DiscardInBuffer();
            }

            lstTelemetry.Items.Add(parsed.ToString());
            lstTelemetry.ScrollIntoView(parsed.ToString());
        }

        private void AutoTelemetryHandler(Object sender, EventArgs args)
        {
            btnRequestTel_Click(null, null);
        }

        private void cbAutoReqTel_Checked(object sender, RoutedEventArgs e)
        {
            m_timerTelem.Start();            
        }

        private void cbAutoReqTel_Unchecked(object sender, RoutedEventArgs e)
        {
            m_timerTelem.Stop();
        }

        private void SendCommand(string cmd)
        {
            if (m_Port.IsOpen)
            {
                m_Port.WriteLine("$" + cmd);
                txtTest.Text = cmd;
            }
        }
    }
}
